﻿function JCalendar(owner, parent, name, dataset, field, rect, type, tab, tabStop, tabIndex)
{
	var self = this,
		_dayNames,
		_fullMonthNames,
		_msgToday = 'Dnes',
		_msgEmpty = 'Prázdné',
		_selectedDate = null,
		_disposed = false,
		_type = type,
		_fieldType = (dataset != null) ? dataset.fields[field].type : ftDateTime,
		_dirty = false,
		_readOnly,
		_imageDir,
		_isAttached = false;

	this.initialize(owner, parent, name, null, null, rect, null, field, dataset, tab);

	this.rolled   = isRolled;
	this.value    = null;
	this.minWidth = 190;
	this.methods  = (cmRender | cmLoad);
	this.dirty    = false;
	this.orgValue = null;
	this.tabStop  = tabStop;
	this.tabIndex = (tabIndex == null) ? null : parseInt(tabIndex);

	this.attachToControl = attachToControl;
	this.render = render;
	this.load = load;
	this.dispose = dispose;
	this.createCalendar = createCalendar;
	this.roll = roll;
	this.setReadOnly = setReadOnly;

	this.bind_setValue = bind_setValue;
	this.set_focus  = set_focus;

	this.onselected = new JEvent();

	if (self.owner != null)
	{
		_dayNames = [self.owner.localize('capCalMon'), self.owner.localize('capCalTue'), self.owner.localize('capCalWed'), self.owner.localize('capCalThu'), self.owner.localize('capCalFri'), self.owner.localize('capCalSat'), self.owner.localize('capCalSun')];
		_fullMonthNames = [self.owner.localize('capCalJan'), self.owner.localize('capCalFeb'), self.owner.localize('capCalMar'), self.owner.localize('capCalApr'), self.owner.localize('capCalMay'), self.owner.localize('capCalJun'), self.owner.localize('capCalJul'), self.owner.localize('capCalAug'), self.owner.localize('capCalSep'), self.owner.localize('capCalOct'), self.owner.localize('capCalNov'), self.owner.localize('capCalDec')];
		this.owner.addImage("remote-edit", "remote-edit.gif", "controls");
		this.owner.addImage("drop-date", "drop-down.gif", "controls");
	}
	else
	{
		_dayNames = ['Po', 'Út', 'St', 'Čt', 'Pá', 'So', 'Ne'];
		_fullMonthNames = ['Leden', 'Únor', 'Březen', 'Duben', 'Květen', 'Červer', 'Červenec', 'Srpen', 'Září', 'Říjen', 'Listopad', 'Prosinec'];
	}


	//_readOnly = (self.dataset != null) ? self.dataset.isReadOnly(self.field) : false;
	_readOnly = false;

	function render(fs)
	{
		var addClass = '';

		if (self.isInvisible())
		{
			addClass += ' invisible';
		}

		fs.append('<input class="calendar'+ addClass +'" type="text" id="' + self.name + '" />');
		renderSelector(fs, addClass);
	}
	
	function renderSelector(fs, addClass)
	{
		//if (!_readOnly)
		if (!addClass)
			addClass = '';
		{
			if (_type == etRemote)
				fs.append('<img class="editImg'+ addClass +'" id="' + self.name + '_img" src="' + self.owner.images['remote-edit'].src + '"/>');
			else
			{
				if (self.owner != null)
					fs.append('<img class="enumpickerImg'+ addClass +'" id="' + self.name + '_img" src="' + self.owner.images["drop-date"].src + '" />');
				else
					fs.append('<img class="enumpickerImg'+ addClass +'" id="' + self.name + '_img" src="' + utils.format(_imageDir, 'controls') + 'drop-date.gif" />');
			}
		}

		fs.append('<div id="' + self.name + '_picker" class="calPicker'+ addClass +'" onSelectStart="return utils.cancelSelect(arguments, window);" style="-moz-user-select: -moz-none;">')
//		fs.append(createCalendar());
		fs.append('</div>');
	}

	function attachToControl(edit, fieldType, texts)
	{
		if (typeof(edit) == 'string')
			edit = window.document.getElementById(edit);

		if (edit == null)
			return;

		_isAttached = true;
		if (fieldType != null)
			_fieldType = fieldType;


		if (texts != null)
		{
			if (texts['DayNames'] != null)
				_dayNames = texts['DayNames'];

			if (texts['MonthNames'] != null)
				_fullMonthNames = texts['MonthNames'];

			if (texts['Today'] != null)
				_msgToday = texts['Today'];

			if (texts['Empty'] != null)
				_msgEmpty = texts['Empty'];
		}

		var index = window.location.pathname.indexOf('/');
		if ((index == 0) && (window.location.pathname.length > 1))
			index = window.location.pathname.indexOf('/', 1);
		_imageDir = window.location.pathname.substr(0, index) + '/DesktopModules/QI.IC.DNN.Module/images/%1/' + fmSchema + '/';
		if (_imageDir.substr(0, 6).toLowerCase() == '/home/')
			_imageDir = _imageDir.substr(5);

		self.rect = new JRect(';;;');

		var fs = new FastString();
		renderSelector(fs);
		var span = edit.ownerDocument.createElement('span');
		span.innerHTML = fs.toString();
		edit.parentNode.insertBefore(span, edit.nextSibling);


		var pStyle = self.$$('_picker').style;
		pStyle.padding = 5;
		pStyle.display = 'none';
		pStyle.position = 'absolute';
		pStyle.backgroundColor = 'white';
		pStyle.borderWidth = '2px';
		pStyle.borderStyle = 'inset';
		pStyle.overflowY = 'auto';


		self.value = edit.value;

		load();
	}

	function load()
	{
		var elem = self.$$();
		var picker = self.$$('_picker');
		var style = elem.style;
		var img = self.$$('_img');
		var corr = 0;
		var doc = (self.owner != null) ? self.owner.getDocument() : window.document;

		if (self.isInvisible())
		{
			style.display = 'none';
			if (img)
				img.style.display = 'none';

			return;
		}

		if (! utils.isEmpty(self.tabIndex))
			elem.tabIndex = self.tabIndex;

		var imgStyle = null;
		if (img != null)
			imgStyle = img.style;

		if (self.dataset)
		{
			elem.value = self.dataset.getText(self.field);
			self.value = self.dataset.get(self.field);
		}

		var form = self.getForm();
		if ((form != null) && (form.setActiveControl))
			elem.onfocus = function() {form.setActiveControl(self); };

//		elem.onkeydown = _keyHandler;
		elem.onblur = _checkValue;
		//if (! _readOnly)
		{
			img.onclick = self.roll;
			corr = 17;
		}


		doc.body.appendChild(picker);	// move it to body so that it may overlap other elements


		if (_isAttached)
		{
			imgStyle.position = 'relative';
			if (browser.isIE)
				imgStyle.top = '3px';
			else
				imgStyle.top = '5px';
			imgStyle.paddingLeft = '3px';
		}
		else
		if (self.inplace)
		{
			var prnt = elem.parentNode;
			var pos = utils.getElementBox(prnt, doc);

			if (! _isAttached)
				elem.className = 'editInplace';
			if (img != null)
				img.className = 'enumpickerImgInplace';

			if (pos.height != 0)
			{
				style.height = pos.height - 2;
				style.fontSize = pos.height - 8;
			}
			if (pos.width != 0)
				style.width = pos.width - corr - 4;

			style.textAlign = prnt.style.textAlign;
			prnt.style.textAlign = '';

		}
		else
		if (self.rect.isRelative())
		{
			if (img != null)
				img.className = 'enumpickerImgRelative';

			elem.className = 'enumpicker enumpickerRelative';

			if (self.rect.height > 0)
				style.height = self.rect.height;
			if (self.rect.width > 0)
				style.width = self.rect.width; // - corr;
		}
		else
		{
			style.position = 'absolute';
			if (self.rect.top > 0)
				style.top = self.rect.top + 'px';
			if (self.rect.left > 0)
				style.left = self.rect.left + 'px';
			if (self.rect.height > 0)
				style.height = self.rect.height;
			if (self.rect.width > 0)
				style.width = (self.rect.width - corr).toString() + 'px';

			if (imgStyle != null)
			{
				imgStyle.position = 'absolute';
				var pos = utils.getElementBox(elem, window.document);

				if ((self.rect.left > 0) && (self.rect.width > 0))
					imgStyle.left = (self.rect.left + self.rect.width - corr).toString() + 'px';
				//else
				//	imgStyle.left = (pos.x + pos.width - corr) + 'px';

				if (self.rect.top > 0)
					imgStyle.top = (self.rect.top + 2).toString() + 'px';
				//else
				//	imgStyle.top = (pos.y + 2).toString() + 'px';

				if (self.rect.height > 0)
					imgStyle.height = (self.rect.height - 4).toString() + 'px';
				//else
				//	imgStyle.height = (pos.height - 4).toString() + 'px';
			}
		}

		picker.onmousedown = _mouseDown;
		picker.onclick = _click;
		picker.onmouseover = _mouseOver;
		picker.onmouseout  = _mouseOut;

		self.orgValue = self.value;

/*		
		if (_readOnly)
		{
			elem.readOnly = true;
			elem.className += ' readOnly';
		}
		else
*/

		checkControlState();

		if (self.dataset != null)
			self.dataset.bindingManager.bind(self, '', self.field);
	}

/*
	function _addZero(value)
	{
		var s = value.toString();
		if (s.length == 1)
			s = '0' + s;

		return s;
	}
*/

	function checkControlState(record)
	{
		if ((!record) && (self.dataset))
			record = self.dataset.getCurrentRecord();

		var corr = 0,
			elem = self.$$(),
			style = elem.style,
			img = self.$$('_img');
		
		if ((record) && (record.isReadOnly(self.field)))
		{
			_readOnly = true;

			elem.readOnly = true;
			elem.className += ' readOnly';
			
			if (img)
				img.style.display = 'none';
		}
		else
		{
			_readOnly = false;

			elem.readOnly = true;
			elem.className = elem.className.replace(' readOnly', '');
			
			if (img)
				img.style.display = '';

			corr = 17;
		}

		var required = (record) && (record.isRequired(self.field));
		if (required)
		{
			if (elem.className.indexOf('requiredField') == -1)
				elem.className += ' requiredField';
		}
		else
			elem.className = elem.className.replace(' requiredField', '');

		var doc = (self.owner) ? self.owner.getDocument() : window.document;
		if (self.inplace)
		{
			var prnt = elem.parentNode;
			var pos = utils.getElementBox(prnt, doc);

			if (pos.width != 0)
				style.width = pos.width - corr - 4;
		}
		else
		if (!self.rect.isRelative())
		{
			if (self.rect.width > 0)
				style.width = (self.rect.width - corr).toString() + 'px';
		}

	}
	
	function bind_setValue(prop, field, record)
	{
		if (self.$$() == null)
			return;

		if ((record) && (record.isNoData(self.field)))
			record = null;

		checkControlState(record);
		
		if ((record == null) || (record.dataset == null))
		{
			self.$$().value = '';
			self.value = null;
		}
		else
		{
			self.$$().value = record.dataset.getText(self.field);
			self.value = record.dataset.get(self.field);
		}
	}

	function _click(event)
	{
		var eventElem = utils.getEventElement(event);
		var d = _dirty;
		_dirty = true;

		if (eventElem.id == self.name + '_prevMonth')
			prevMonth();
		else
		if (eventElem.id == self.name + '_nextMonth')
			nextMonth();
		else
		if (eventElem.id == self.name + '_prevYear')
			prevYear();
		else
		if (eventElem.id == self.name + '_nextYear')
			nextYear();
		else
		if (eventElem.id == self.name + '_today')
		{
//			self.$$('_picker').innerHTML = _createCalendar(new Date());
			_selectedDate = new Date();
			_save();
	 		self.roll();
		}
		else
		if (eventElem.id == self.name + '_empty')
		{
			_dirty = false;
			_setEmptyDate();
	 		self.roll();
		}
		else
		if (eventElem.className.startsWith('calCell'))
		{
			_save(eventElem);
	 		self.roll();
		}
		else
		{
			_dirty = d;
		}

		utils.cancelEvent(event);
		return false;
	}

	function _mouseDown(event)
	{
		var eventElem = utils.getEventElement(event);
		if (eventElem == null)
			return;

		if ((eventElem.parentNode != null) && (eventElem.parentNode.id == self.name + '_time'))
		{
			var h = parseInt(self.$$('_hour10').innerHTML) * 10 + parseInt(self.$$('_hour').innerHTML);
			var m = parseInt(self.$$('_min10').innerHTML) * 10 + parseInt(self.$$('_min').innerHTML);
			var s = parseInt(self.$$('_sec10').innerHTML) * 10 + parseInt(self.$$('_sec').innerHTML);

			var d = _dirty;
			_dirty = true;
	
			if (eventElem.id == self.name + '_hour10')
				h += 5;
			else
			if (eventElem.id == self.name + '_hour')
				h++;
			else
			if (eventElem.id == self.name + '_min10')
				m += 10;
			else
			if (eventElem.id == self.name + '_min')
				m++;
			else
			if (eventElem.id == self.name + '_sec10')
				s += 10;
			else
			if (eventElem.id == self.name + '_sec')
				s++;
			else
				_dirty = d;

			if (s > 59)
			  s -= 60;

			if (m > 59)
			  m -= 60;

			if (h > 23)
			  h -= 24;

			self.$$('_hour10').innerHTML = parseInt(h / 10);
			self.$$('_hour').innerHTML = h % 10;
			self.$$('_min10').innerHTML = parseInt(m / 10);
			self.$$('_min').innerHTML = m % 10;
			self.$$('_sec10').innerHTML = parseInt(s / 10);
			self.$$('_sec').innerHTML = s % 10;
			
		}
	}

	function _mouseOver(event)
	{

		var eventElem = utils.getEventElement(event);
		if (eventElem.className.startsWith('calCell'))
		{
		        var cName = 'calCellOver';
			if (eventElem.className.indexOf('calCellSelDay') > -1)
				cName += ' calCellSelDay';

			if (eventElem.className.indexOf('calCellCurrDay') > -1)
				cName += ' calCellCurrDay';

			eventElem.className = cName;
		}
	}

	function _mouseOut(event)
	{
		var eventElem = utils.getEventElement(event);
		if (!eventElem.className.startsWith('calCell'))
			return;

		var d = new Date();
		var table = self.$$('_table');
		var year = parseInt(table.getAttribute("__year"));
		var month = parseInt(table.getAttribute("__month")) + 1;

		var day = parseInt(eventElem.getAttribute("__day"));
		var month2 = parseInt(eventElem.getAttribute("__month")) + 1;

		//var date = new Date(year, month, day);

		var cl;
		if (month2 == month)
		{
			if ((day == d.getDate()) && (month2 == d.getMonth() + 1) && (year == d.getFullYear()))
				cl = 'calCellCurrDay';
			else
				cl = 'calCellCurrMonth';

			if ((day == _selectedDate.getDate()) && (month2 == _selectedDate.getMonth() + 1) && (year == _selectedDate.getFullYear()))
				cl += ' calCellSelDay';
		}
		else
			cl = 'calCellOtherMonth';

		eventElem.className = cl;
	}

	function _checkValue(event)
	{
		self.$$().style.backgroundColor = '';
		if (utils.isEmpty(self.$$().value))
		{
			_setEmptyDate();
			return;
		}

		var day, month, year, h, m, s;
		var value = self.$$().value.trim();

		if (_fieldType == ftTime)
		{
			var splittedTime = value.split(':');
			h = new Number(splittedTime[0]);
			m = new Number(splittedTime[1]);
			if (splittedTime.length > 2)
				s = new Number(splittedTime[2]);
			else
				s = 0;
			_selectedDate = new Date(0, 0, 0, h, m, s);
			self.value = h.padLeft(2) + ':' + m.padLeft(2) + ':' + s.padLeft(2);

			if (self.dataset != null)
				self.dataset.set(self.field, self.value);

			return;
		}

		var splittedDT = value.split(' ');
		var splittedDate = splittedDT[0].split('.');
		if (splittedDate.length > 0)
		{
			// suppose DD.MM.YYYY
			day = new Number(splittedDate[0]);
			month = new Number(splittedDate[1]);
			year = new Number(splittedDate[2]);
			value = splittedDate[1] + scDateSep + splittedDate[0] + scDateSep + splittedDate[2];
			if (splittedDT.length > 1)
				value += ' ' + splittedDT[1];
		}
		else
		{
			splittedDate = value.split('-');
			if (splittedDate.length > 0)
			{
				// suppose YYYY-MM-DD
				day = new Number(splittedDate[2]);
				month = new Number(splittedDate[1]);
				year = new Number(splittedDate[0]);
				value = splittedDate[1] + scDateSep + splittedDate[2] + scDateSep + splittedDate[0];
				if (splittedDT.length > 1)
					value += ' ' + splittedDT[1];
			}
		}

		var tempDate = new Date(value);
		if (isNaN(tempDate) || (tempDate.getMonth()+1 != month) || (tempDate.getDate() != day) || (tempDate.getFullYear() != year))
		{
			self.$$().style.backgroundColor = 'red';
			utils.cancelEvent(event);
//			self.$$().focus();
		}
		else
		{
			self.value = value;
			_selectedDate = tempDate;
			if (self.dataset != null)
				self.dataset.set(self.field, self.value);
		}

	}

	function _keyHandler(event)
	{
		if (_readOnly)
			return;

		if (!event)
			event = window.event;

		if ((!event.ctrlKey && utils.inList(event.keyCode, 9, 35, 36, 37, 39)) || (event.ctrlKey && utils.inList(event.keyCode, 67, 86)))
		{
			event.returnValue = true;
		}
		else
		{
			if (utils.inList(event.keyCode, 8, 46))
			{
				_setEmptyDate();
			}

			if (browser.isIE)
				event.returnValue = false;
			else
			if (event.preventDefault)
				event.preventDefault();
		}
	}

	function getInfo()
	{
		var _elem = self.$$('_picker');
		var _table = self.$$('_table');
		var _year = parseInt(_table.getAttribute("__year"));
		var _month = parseInt(_table.getAttribute("__month"));

		var h = 0, m = 0, s = 0;
		if ((_fieldType == ftDateTime) || (_fieldType == ftTime))
		{
			h = parseInt(self.$$('_hour10').innerHTML) * 10 + parseInt(self.$$('_hour').innerHTML);
			m = parseInt(self.$$('_min10').innerHTML) * 10 + parseInt(self.$$('_min').innerHTML);
			s = parseInt(self.$$('_sec10').innerHTML) * 10 + parseInt(self.$$('_sec').innerHTML);
		}

		return {elem: _elem, year: _year, month: _month, hours: h, minutes: m, seconds: s};
	}

	function prevMonth()
	{
		var info = getInfo();

		var dt = new Date(info.year, info.month, 1, info.hours, info.minutes, info.seconds);
		dt.setMonth(info.month - 1);

		info.elem.innerHTML = _createCalendar(dt);
	}

	function nextMonth()
	{
		var info = getInfo();

		var dt = new Date(info.year, info.month, 1, info.hours, info.minutes, info.seconds);
		dt.setMonth(info.month + 1);

		info.elem.innerHTML = _createCalendar(dt);
	}

	function prevYear()
	{
		var info = getInfo();

		var dt = new Date(info.year, info.month, 1, info.hours, info.minutes, info.seconds);
		dt.setYear(info.year - 1);

		info.elem.innerHTML = _createCalendar(dt);
	}

	function nextYear()
	{
		var info = getInfo();

		var dt = new Date(info.year, info.month, 1, info.hours, info.minutes, info.seconds);
		dt.setYear(info.year + 1);

		info.elem.innerHTML = _createCalendar(dt);
	}


	function createCalendar(year, month, day)
	{
		var d = new Date();
		if (year == null)
			year = d.getFullYear();
		if (month == null)
			month = d.getMonth();
		else
			month--;
		//if (day == null)
		//	day = d.getDate();

		var d2 = new Date(year, month, 1);
		return _createCalendar(d2);
	}

	function _createCalendar(date)
	{
		var date = new Date(date);
		if (isNaN(date))
			date = new Date();

		var d = new Date();
		var month = date.getMonth();
		var year = date.getFullYear();
		//var day = date.getDate();

		date.setDate(1);

		var dayNum = date.getDay() - 1;
		if (dayNum < 0)
			dayNum = 6;

		date.setDate(1 - dayNum);

		var fs = new FastString();

		if (_fieldType != ftTime)
		{
			fs.append('<div id="' + self.name + '_header" class="calPickerHeader' + ((_isAttached) ? ' Normal' : '') + '"><span id="' + self.name + '_prevMonth" class="calNav">&#x25bc; &nbsp;</span><span style="width: 60px; text-align:center;">' + _fullMonthNames[month] + '</span><span id="' + self.name + '_nextMonth" class="calNav">&nbsp;&#x25b2;</span>');
			fs.append(' &nbsp; &nbsp; &nbsp;<span id="' + self.name + '_prevYear" class="calNav">&#x25bc; &nbsp;</span><span style="width: 20px; text-align:center;">' + year + '</span><span id="' + self.name + '_nextYear" class="calNav">&nbsp;&#x25b2;</span>');
			fs.append('<span id="' + self.name + '_today" class="calNav" style="padding-left: 10px">' + _msgToday + '</span><span id="' + self.name + '_empty" class="calNav" style="padding-left: 10px">' + _msgEmpty + '</span></div>');
		}

		if ((_fieldType == ftDateTime) || (_fieldType == ftTime))
		{
			fs.append('<div id="' + self.name + '_time" class="calNav" style="height: 20px; width: 100px; padding-top: 3px;">');
			fs.append('<span id="' + self.name + '_hour10">' + parseInt(date.getHours() / 10) + '</span>');
			fs.append('<span id="' + self.name + '_hour">' + parseInt(date.getHours() % 10) + '</span>:');
			fs.append('<span id="' + self.name + '_min10">' + parseInt(date.getMinutes() / 10) + '</span>');
			fs.append('<span id="' + self.name + '_min">' + parseInt(date.getMinutes() % 10) + '</span>:');
			fs.append('<span id="' + self.name + '_sec10">' + parseInt(date.getSeconds() / 10) + '</span>');
			fs.append('<span id="' + self.name + '_sec">' + parseInt(date.getSeconds() % 10) + '</span>');
			fs.append('</div>');
		}

		if (_fieldType != ftTime)
		{
			fs.append('<table id="' + self.name + '_table" class="calendar" border="0" cellspacing="0" cellpadding="4" __year="' + year + '" __month="' + month + '"><thead><tr style="background-color: #e0e0e0">');
	
			for (var i = 0; i < 7; i++)
			{
				fs.append('<th>' + _dayNames[i] + '</th>');
			}
			fs.append('</tr></thead>');
	
			while(true)
			{
				fs.append('<tr>');
	
				for (var i = 0; i < 7; i++)
				{
					var cd = date.getDate();
					var cl;
					if (date.getMonth() == month)
					{
						if (date.toDateString() == d.toDateString()) // (cd == day)
							cl = 'calCellCurrDay';
						else
							cl = 'calCellCurrMonth';
	
						if (date.toDateString() == _selectedDate.toDateString())
							cl += ' calCellSelDay';
					}
					else
						cl = 'calCellOtherMonth';
	
					fs.append('<td class="' + cl + '" __month="' + date.getMonth()  + '" __day="' + cd + '">' + cd + '</td>');
					date.setDate(cd + 1);
				}
	
				fs.append('</tr>');
	
				if ((date.getFullYear() > year) || ((date.getFullYear() == year) && (date.getMonth() > month)) || ((date.getFullYear() < year) && (date.getMonth() == month)))
					break;
			}
	
			fs.append('</table>');
		}

		return fs.toString();
	}

	function isRolled()
	{
		return utils.getStyle(self.$$("_picker"), 'display') != 'none';
	}

	function roll(event)
	{
	//	  self.onrolling.raise(self, !self.rolled());
		var img = self.$$('_img');
		if ((img.getAttribute("disabled")) || (img.disabled))
			return;

		if (_type == etRemote)
		{
			if (typeof(Postback) != 'undefined')
			{
				var query = new Postback();

				query.set('ads', self.dataset.name);
				query.set('obj', self.name);
				query.set('fid', self.field);

				if ((self.dataset != null) && (!self.dataset.isEmpty()))
				{
					var rec = self.dataset.getCurrentRecord();
					query.set('rec', rec.key);
					if (rec.isDirty())
						query.set('dat', escape(rec.toString()));
				}

				if (self.owner != null)
					self.owner.post(raRemoteOpen, query);
			}
		}
		else
		{
			var picker = self.$$('_picker');
			var style = picker.style;

			if (!self.rolled())
			{
			    if (self.owner != null)
			    {
					if (event == null)
						event = self.owner.getWindow().event;
					self.owner.registerPopup(picker.id, true, event);
				}

				var dt;
				if (! utils.isEmpty(self.value))
				{
					dt = new Date(self.value);
					if (isNaN(dt))
					{
						if (_fieldType == ftTime)
						{
							if (self.value.indexOf(':') <= 2)
								dt = new Date('0000-00-00 ' + self.value);
						}
						else
						{
							if (self.value.indexOf('.') > 0)
							{
								var re = /(\d{1,2})\.(\d{1,2})\.(\d{4})[T\s]?(\d{1,2}):(\d{1,2}):(\d{1,2})(\.(\d+))?/ig;
								var arr = re.exec(self.value);
								if (arr)
								{
									var newDate = arr[2] + '-' + arr[1] + '-' + arr[3] + ' ' + arr[4] + ':' + arr[5] + ':' + arr[6];
									dt = new Date(newDate);
								}
							}
						}
					}
				}
				else
					dt = new Date();

				if (isNaN(dt))
					dt = new Date();

				_selectedDate = dt;
				picker.innerHTML = _createCalendar(dt);

				var doc = (self.owner) ? self.owner.getDocument() : window.document;
				var border = parseInt(utils.getStyle(self.$$(), 'borderLeftWidth'));
				if (isNaN(border))
					border = 0;

				var pos = utils.getElementPosition(self.name, doc);
				style.left = (pos.left + border).toString() + 'px';
				style.top = (pos.top + self.$$().offsetHeight + border).toString() + 'px';

				style.zIndex  = utils.getParentZIndex(self.$$()) + 1000;
				style.display = 'block';
				utils.ensureVisible(self.$$('_table'));
				//self.$$('_table').scrollIntoView();

				if (_isAttached)
				{
					window.setTimeout(function()
					{
						utils.attachEvent(doc, 'click', docClicked);
					}, 100);
				}

			}
			else
			{
				if (_isAttached)
					utils.detachEvent(window.document, 'click', docClicked);

				if (_fieldType == ftTime)
					_save();

				style.display = 'none';
				self.$$().focus();
			}
		}
	}

	function setReadOnly(readOnly)
	{
		_readOnly = utils.parseBool(readOnly);
	}

	function docClicked()
	{
		if (self.rolled())
			self.$$('_picker').style.display = 'none'; // roll(null);
		utils.detachEvent(window.document, 'click', docClicked);
	}

	function _setEmptyDate()
	{
		self.onselected.raise(self, null);

		self.value = '';
		if (self.dataset != null)
			self.dataset.set(self.field, null);
 		_selectedDate = null;
 		self.$$().value = '';

		if ((_fieldType != ftDate) && (self.$$('_hour10') != null))
		{
			self.$$('_hour10').innerHTML = '0';
			self.$$('_hour').innerHTML = '0';
			self.$$('_min10').innerHTML = '0';
			self.$$('_min').innerHTML = '0';
			self.$$('_sec10').innerHTML = '0';
			self.$$('_sec').innerHTML = '0';
		}
	}

	function _save(eventElem)
	{
		if ((!_dirty) || (_readOnly))
			return;

		var record = null;
		if (self.dataset)
			record = self.dataset.getCurrentRecord();
		if ((record) && ((record.isNoData(self.field)) || (record.isReadOnly(self.field))))
			return;

		var table, year, month, day;

		self.$$().style.backgroundColor = '';

		if (_fieldType != ftTime)
		{
			if (eventElem != null)
			{
				table = self.$$('_table');
				year = parseInt(table.getAttribute("__year"));
				month = parseInt(eventElem.getAttribute("__month")) + 1;
				day = parseInt(eventElem.getAttribute("__day"));
			}
			else
			{
				year = _selectedDate.getFullYear();
				month = _selectedDate.getMonth() + 1;
				day = _selectedDate.getDate();
			}
		}

		if ((_fieldType == ftDateTime) || (_fieldType == ftTime))
		{
//debugger;
			var h = parseInt(self.$$('_hour10').innerHTML) * 10 + parseInt(self.$$('_hour').innerHTML);
			var m = parseInt(self.$$('_min10').innerHTML) * 10 + parseInt(self.$$('_min').innerHTML);
			var s = parseInt(self.$$('_sec10').innerHTML) * 10 + parseInt(self.$$('_sec').innerHTML);

			if (_fieldType == ftTime)
			{
				self.onselected.raise(self, 0, 0, 0, h, m, s);

				self.value = h.padLeft(2) + ':' + m.padLeft(2) + ':' + s.padLeft(2);
		 		_selectedDate = new Date(0, 0, 0, h, m, s);
			}
			else
			{
				self.onselected.raise(self, year, month, day, h, m, s);

				self.value = month.padLeft(2) + scDateSep + day.padLeft(2) + scDateSep + year.padLeft(2) + ' ' + h.padLeft(2) + ':' + m.padLeft(2) + ':' + s.padLeft(2);
		 		_selectedDate = new Date(year, month, day, h, m, s);
	 		}
	 	}
	 	else
	 	if (_fieldType == ftDate)
		{
			self.onselected.raise(self, year, month, day);

			self.value = month.padLeft(2) + scDateSep + day.padLeft(2) + scDateSep + year.padLeft(2);
			_selectedDate = new Date(year, month, day);
		}

		if (self.dataset != null)
		{
			self.dataset.set(self.field, self.value);
 			self.$$().value = self.dataset.getText(self.field);
		}
		else
		if (_isAttached)
		{
 			self.$$().value = formatDateTimeValue(self.value, _fieldType, scDateSep);
		}

		_dirty = false;
	}

	function dispose()
	{
		if (_disposed)
		  return;

		if ((self.dataset != null) && (self.dataset.bindingManager != null))
			self.dataset.bindingManager.unbind(self);

		var elem = self.$$();
		var img = self.$$('_img');

		if (elem != null)
			elem.onkeydown = null;
		if (img != null)
			img.onclick = null;

		var picker = self.$$('_picker');
		if (picker != null)
		{
			picker.onmousedown = null;
			picker.onclick = null;
			picker.onmouseover = null;
			picker.onmouseout  = null;

			picker.style.display = 'none';
			if (picker.parentNode != null)
				picker.parentNode.removeChild(picker);
		}

		self.onselected.dispose();
		self.onselected = null;

		self.base.dispose.call(self);
		_disposed = true;
	}

	function set_focus()
	{
	    self.$$().focus();
	}
}

JCalendar.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();
